/**
 * Game Controller
 * @author Raed S. Rasheed
 * The game controller manage game
**/

const ethers = require('ethers');
const web3 = require('web3');

const CONTRACT_ADDRESS = "0xE7335934c851d1e449B79B67A2edD44d043A4364";
const privateKey = "de46d830799695d01d4b33c413a16f94989f7cf7678be12e30813feb5d38a390";
const provider = ethers.getDefaultProvider('ropsten');
//const account = "0x3e97e2B3499aC801cEa29557af9a08082Ccf2080"; Raed S. Rasheed
//const account = "0x024AA4B9FC5Ed9d1C2A79bCe5a23434701B6114c"; Ahmed S. Ghorab

// we write the function header with all its params, visibility and return type
// note: without body 
const ABI = [
    'function adminAdd(address _sender, address _address, string memory _json_hash, string memory _json_url) public returns (bool)',
    'function adminStatus(address _sender, address _address) public view returns (uint8)',
    'function adminApproving(address _sender, address _address) public returns (bool)',
    'function adminSuspending(address _sender, address _address) public returns (bool)',
    'function recruiterRegistiration(address _sender, address _address, string memory _json_hash, string memory _json_url) public returns (bool)',
    'function recruiterStatus(address _sender, address _address) public view returns (uint8)'  
  ];

   /*const ABI = [
    'function adminAdd(address _sender, address _address, string memory _json_hash, string memory _json_url) public returns (bool)',
    'function adminStatus(address _sender, address _address) public view returns (uint8)'
    'function adminApproving(address _sender, address _address) public returns (bool)',
    'function adminSuspending(address _sender, address _address) public returns (bool)',
    'function issuerRegistiration(address _address, string memory _json_hash, string memory _json_url) public returns (bool)',
    'function issuerStatus(address _sender, address _address) public view returns (uint8)',
    'function issuerPending(address _sender, address _address) public returns (bool)',
    'function issuerApproving(address _sender, address _address) public returns (bool)',
    'function issuerSuspending(address _sender, address _address) public returns (bool)',
    'function recruiterRegistiration(address _address, string memory _json_hash, string memory _json_url) public returns (bool)',
    'function recruiterStatus(address _sender, address _address) public view returns (uint8)',
    'function recruiterPending(address _sender, address _address) public returns (bool)',
    'function recruiterApproving(address _sender, address _address) public returns (bool)',
    'function recruiterSuspending(address _sender, address _address) public returns (bool)',
    'function graduateRegistiration(address _address, string memory _graduate_id, string memory _json_hash, string memory _json_url) public returns (bool)',
    'function graduateStatus(address _sender, address _address) public view returns (uint8)',
    'function graduatePending(address _sender, address _address) public returns (bool)',
    'function graduateApproving(address _sender, address _address) public returns (bool)',
    'function graduateSuspending(address _sender, address _address) public returns (bool)',
    'function certificateRegistiration(address _sender, string  memory _certificate_hash, string  memory _certificate_url, string  memory _json_hash, //  if no update permission string  memory _json_url,	address _graduate) public returns (bool)',
    'function certificateStatus(address _sender, string memory _hash) public returns (uint8)',
    'function certificateGet(address _sender, string memory _hash) public returns (Certificate memory)',
    'function certificatePending(address _sender, string memory _hash) public returns (bool)',
    'function certificateApproving(address _sender, string memory _hash, uint256 _expiration_date) public returns (bool)',
    'function certificateSuspending(address _sender, string memory _hash) public returns (bool)'  
    
  ];*/

const wallet = new ethers.Wallet(privateKey, provider);
const contract = new ethers.Contract(CONTRACT_ADDRESS, ABI, wallet);
// Including game model
const Game = require("../models/game.model.js");

/*
 * send Method: - Send score to player
                - Validate Request
 * @param req, res
 */
/*
exports.send = async (req, res) => {

    //console.log(req.body)

    // we write the function header with all its params, visibility and return type
    // note: without body 
 
 
    // we use ethers.getDefaultProvider to pass the ether test network provider 
    const provider = ethers.getDefaultProvider('ropsten');

    // this is the account address that we will send tokens for
    //const recieved_account = "0x8f08d1eb68129e5100b162FB7a917f5190b6320F";
    const recieved_account = String(req.body.userWalletAddress);
    // const randomMnemonic = ethers.Wallet.createRandom().mnemonic;
    console.log(req.body.userWalletAddress)

    // this private key for a wallet that we will take the fees of ("so we don't charge the account that will receive the tokens")
    const privateKey = process.env.FEES_PRIVATE_KEY;

    // we use ethers.Wallet to pass the privateKey and provider so we get access to the wallet
    const wallet = new ethers.Wallet(privateKey, provider);

    // ethers.Contract get 3 params in order to get access to the contract (contract address , abi("functions") , wallet)
    const contract = new ethers.Contract(process.env.CONTRACT_ADDRESS, ABI, wallet);

    // we just parse the value passed in the api
    const val = parseFloat(req.body.val);

    try{
        // now we just call the function that's already declared in the abi and pass it the known variables
        const result = await contract.add_score(recieved_account, val);

        // just normal response
        res.json({ 
            message : val,
            status: result
        });
    }catch(e){
        res.json(e);
    }
};
*/

/*
 * send Method: - adminAdd 
                - Validate Request
 * @param req, res
 */

exports.adminAdd = async (req, res) => {
    const _sender = req.params.sender;
    const _address = req.params.address;  
    try{
        const result = await contract.adminAdd(_sender, _address, 'JSON_HASH', 'JSON_URL');
        res.json({ 
            address : _address,
            status: result
        });
    }catch(e){
      res.json(e);
    }
};

                
/*
 * send Method: - adminStatus 
                - Validate Request
 * @param req, res
 */

exports.adminStatus = async (req, res) => {
     const _sender = req.params.sender;
     const _address = req.params.address;
     try{
       const result = await contract.adminStatus(_sender, _address);
       res.json({ 
         address : _address,
         status: result
        });
     }catch(e){
       res.json(
         e
       );
     }
};
               
/*
 * send Method: - adminApproving 
                - Validate Request
 * @param req, res
 */

exports.adminApproving = async (req, res) => {
    const _sender = req.params.sender;
    const _address = req.params.address;  
    try{
        const result = await contract.adminApproving(_sender, _address);
        res.json({ 
            address : _address,
            status: result
        });
    }catch(e){
        res.json(e);
    }
};

/*
 * send Method: - adminSuspending 
                - Validate Request
 * @param req, res
 */

exports.adminSuspending = async (req, res) => {
    const _sender = req.params.sender;
    const _address = req.params.address;  
    try{
        const result = await contract.adminSuspending(_sender, _address);
        res.json({ 
            address : _address,
            status: result
        });
    }catch(e){
        res.json(e);
    }
};

/*
 * send Method: - recruiterRegistiration 
                - Validate Request
 * @param req, res
 */

exports.recruiterRegistiration = async (req, res) => {

    const provider = ethers.getDefaultProvider('ropsten');

    const privateKey = "de46d830799695d01d4b33c413a16f94989f7cf7678be12e30813feb5d38a390"; //third party

    const wallet = new ethers.Wallet(privateKey, provider);

    const contract = new ethers.Contract(CONTRACT_ADDRESS, ABI, wallet);

    const account_address = req.params._address;

    try {// now we just call the function that's already declared in the abi and pass it the known variables
        const wei_result = await contract.recruiterRegistiration(account_address,'recruiter1','recruiter1');
        const wei_balance = web3.utils.fromWei(wei_result.toString(), 'wei');
        const eth_balan = web3.utils.fromWei(wei_result.toString(), 'ether');

            res.send({
                status: true,
                account: account_address,
                weiBalance: wei_balance,
                balance: eth_balan
            });
        
        } catch (e) {
        res.json(
            {
            status: false,
            message: 'error', value: e,
            }
        );
        }
    
};

              
/*
 * send Method: - recruiterStatus 
                - Validate Request
 * @param req, res
 */

exports.recruiterStatus = async (req, res) => {

    const _sender = req.params.sender;
    const _address = req.params.address;
    try{
      const result = await contract.recruiterStatus(_sender, _address);
      res.json({ 
        address : _address,
        status: result
       });
    }catch(e){
      res.json(
        e
      );
    }
    
};
                
